/*global define */
/*jslint white: true */

/*
	This module lists various keyboard code constants.
*/

define(function () {
	"use strict";

	function getKeyGraphPrefix ()
	{
		return "Keyboard/";
	}

	function getKeyCode (inKeyString) 
	{
		return inKeyString.charCodeAt(0);
	}
	
	function getKeyGraphId (inKeyCode) 
	{
		var result, prefix = getKeyGraphPrefix();
		if (inKeyCode.constructor === String) {
			result = prefix + getKeyCode(inKeyCode);
		} else {
			result = prefix + inKeyCode.toString();
		}
		return result;
	}
	
	var keyCodesTable = {
		tabKey: 65539,
		returnKey: 65540,
		shiftKey: 65586,
		ctrlKey: 65585,
		altKey: 65584,
		cmdKey: 65583,
		startKey: 131071,
		capsLockKey: 65587,
		upKey: 65580,
		downKey: 65581,
		leftKey: 65578,
		rightKey: 65579,
		getKeyCode : getKeyCode,
		getKeyGraphPrefix : getKeyGraphPrefix,
		getKeyGraphId : getKeyGraphId
	};

	return keyCodesTable;
});
